% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_related.R
\name{plot.cmp}
\alias{plot.cmp}
\title{Plot Diagnostic for a \code{glm.cmp} Object}
\usage{
\method{plot}{cmp}(x, which = c(1L, 2L, 6L, 8L),
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  bins = 10, ...)
}
\arguments{
\item{x}{an object class 'cmp' object, obtained from a call to \code{glm.cmp}}

\item{which}{if a subset of plots is required, specify a subset of the numbers 1:8. 
See 'Details' below.}

\item{ask}{logical; if \code{TRUE}, the user is asked before each plot.}

\item{bins}{numeric; the number of bins shown in the PIT histogram or the 
PIT Q-Q plot.}

\item{...}{other arguments passed to or from other methods (currently unused).}
}
\description{
Eight plots (selectable by \code{which}) are currently available: 
a plot of deviance residuals against fitted values, 
a non-randomized PIT histogram, 
a uniform Q-Q plot for non-randomzied PIT, 
a histogram of the normal randomized residuals, 
a Q-Q plot of the normal randomized residuals, 
a Scale-Location plot of sqrt(| residuals |) against fitted values
a plot of Cook's distances versus row lobels
a plot of pearson residauls against leverage. 
By default, four plots (number 1, 2, 6, and 8 from this list of plots) are provided.
}
\details{
The 'Scale-Location' plot, also called 'Spread-Loation' plot, takes the square root of 
the absolute standardized deviance residuals (\emph{sqrt|E|}) in order to diminish 
skewness is much less skewed than than \emph{|E|} for Gaussian zero-mean E. 

The 'Scale-Location' plot uses the standardized deviance residuals while the 
Residual-Leverage plot uses the standardized pearson residuals. They are given as 
\emph{R[i]/sqrt(1-h.ii)} where h_ii are the diagonal entries of the hat matrix.  

The Residuals-Leverage plot shows contours of equal Cook's distance for values of 0.5 
and 1. 

There are two plots based on the non-randomized probability integral transformation (PIT) 
using \code{\link{compPIT}}. These are a histogram and a uniform Q-Q plot. If the 
model assumption is appropriate, these plots should reflect a sample obtained 
from a uniform distribution. 

There are also two plots based on the normal randomzied residuals calculated 
using \code{\link{compnormRandPIT}}. These are a histogram and a normal Q-Q plot. If the model
assumption is appropriate, these plots should reflect a sample obtained from a normal
distribuiton.
}
\examples{
data(takeoverbids)
M.bids <- glm.cmp(numbids ~ leglrest + rearest + finrest + whtknght 
    + bidprem + insthold + size + sizesq + regulatn, data=takeoverbids)

## The default plots are shown
plot(M.bids)

## The plots for the non-randomzied PIT 
# plot(M.bids, which = c(2,3))
}
\seealso{
\code{\link{compPIT}}, \code{\link{compnormRandPIT}}, \code{\link{glm.cmp}}
}
