% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.mpoly.R
\name{print.mpoly}
\alias{print.mpoly}
\title{Pretty printing of multivariate polynomials.}
\usage{
\method{print}{mpoly}(x, varorder, order, stars = FALSE,
  silent = FALSE, ...)
}
\arguments{
\item{x}{an object of class mpoly}

\item{varorder}{the order of the variables}

\item{order}{a total order used to order the monomials in the 
printing}

\item{stars}{print the multivariate polynomial in the more 
computer-friendly asterisk notation (default FALSE)}

\item{silent}{logical; if TRUE, suppresses output}

\item{...}{additional parameters to go to \code{\link{cat}}}
}
\value{
Invisible string of the printed object.
}
\description{
This is the major function used to view multivariate polynomials.
}
\examples{
p <- mp("2 x^5  -  3 y^2  +  x y^3")
p
print(p) # same
print(p, silent = TRUE)
s <- print(p, silent = TRUE)
s

print(p, order = "lex") # -> 2 x^5  +  x y^3  -  3 y^2
print(p, order = "lex", varorder = c("y","x")) # -> y^3 x  -  3 y^2  +  2 x^5
print(p, varorder = c("y","x")) # -> 2 x^5  -  3 y^2  +  y^3 x

print(p, stars = TRUE)

}
