% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_QTLxEC.R
\name{plot_QTLxEC}
\alias{plot_QTLxEC}
\title{plot QTLxEC effect}
\usage{
plot_QTLxEC(
  Qeff,
  Q_id,
  RP = "RP",
  EC_id = "EC",
  trait_id = "trait",
  main = "QTLxEC",
  keep_par = NULL,
  rem_par = NULL,
  text_size = 14
)
}
\arguments{
\item{Qeff}{output from the function \code{\link{QTL_effect_QxEC}} obtained
with option QTLxEC_plot = TRUE.}

\item{Q_id}{\code{Numeric value} indicating which QTL to plot}

\item{RP}{\code{Character} string indicating the name of the reference (central) parent.
Default = 'RP'.}

\item{EC_id}{\code{Character} string indicating the name of the environmental covariate.
Default = 'EC'.}

\item{trait_id}{\code{Character} string indicating the name of the trait.
Default = 'trait'.}

\item{main}{\code{Character} string title of the plot. Default = 'QTLxEC'}

\item{keep_par}{\code{Character} vector or string specifying the only parents that
should be ploted. Default = NULL.}

\item{rem_par}{\code{Character} vector or string specifying the parents that
should not be ploted. Default = NULL.}

\item{text_size}{\code{Numerical} value specifying the size of the text in the plot.
Default = 14.}
}
\value{
QTLxEC sensitivity plot
}
\description{
Plot allowing the visualisation of the QTL allelic effect given an
environmental covariate (EC). It represents parental QTL effects that
significantly interact with the EC. Those values are added to the (central)
reference parent effect (intercept) which allow a comparison of the
parental allele contribution with respect to the reference and in the scale
of the trait.
}
\examples{

\dontrun{

data(mppData_GE)

Qpos <- c("PZE.105068880", "PZE.106098900")

EC <- matrix(c(180, 310, 240, 280), 4, 1)
rownames(EC) <- c('CIAM', 'TUM', 'INRA', 'KWS')
colnames(EC) <- 'cum_rain'

Qeff <- QTL_effect_QxEC(mppData = mppData_GE,
                         trait = c('DMY_CIAM', 'DMY_TUM', 'DMY_INRA_P', 'DMY_KWS'),
                         env_id = c('CIAM', 'TUM', 'INRA', 'KWS'),
                         QTL = Qpos, EC = EC)

pl <- plot_QTLxEC(Qeff, Q_id = 2, RP = "UH007", EC_id = 'cum rain',
trait_id = 'DMY')

}

}
\author{
Vincent Garin
}
