% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/records_by_type.R
\name{mr_records_by_type}
\alias{mr_records_by_type}
\title{Get Marineregions records by place type}
\usage{
mr_records_by_type(type, offset = 0, ...)
}
\arguments{
\item{type}{(character) One place type name. See
\code{\link{mr_place_types}} for place type names}

\item{offset}{(numeric) Offset to start at. Each request can return up to
100 results. e.g., an offset of 200 will give records 200 to 299.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
If no results, an empty list. If results found, a data.frame with the columns:
\itemize{
 \item MRGID (integer)
 \item gazetteerSource (character)
 \item placeType (character)
 \item latitude (numeric)
 \item longitude (numeric)
 \item minLatitude (numeric)
 \item minLongitude (numeric)
 \item maxLatitude (numeric)
 \item maxLongitude (numeric)
 \item precision (numeric)
 \item preferredGazetteerName (character)
 \item preferredGazetteerNameLang (character)
 \item status (character)
 \item accepted (integer)
}
}
\description{
Get Marineregions records by place type
}
\details{
Internally we use the \code{getGazetteerRecordsByType.json} API
method, which searches for Marineregions records by user supplied place type
}
\examples{
\dontrun{
# Get records of type 'EEZ', then inspect data.frame
res <- mr_records_by_type(type="EEZ")
head(res)

# You can use mr_place_types() function to get types
## then pass those into this function
types <- mr_place_types()
mr_records_by_type(types$type[1])
mr_records_by_type(types$type[10])

# use regex to find a type name matching a pattern
x <- grep("MEOW", types$type, value = TRUE)

# then pass to the function
mr_records_by_type(x)
mr_records_by_type(x, offset = 100)
}
}
