% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsim_q.R
\name{mrgsim_q}
\alias{mrgsim_q}
\title{Simulate from a model object with quicker turnaround}
\usage{
mrgsim_q(x, data, recsort = 1, stime = numeric(0),
  output = "mrgsims", skip_init_calc = FALSE, simcall = 0)
}
\arguments{
\item{x}{a model object}

\item{data}{a simulation data set}

\item{recsort}{record sorting flag}

\item{stime}{a numeric vector of observation times; these observation
times will only be added to the output if there are no observation
records in \code{data}}

\item{output}{output data type; if \code{mrgsims}, then the default output
object is returned; if \code{"df"} then a data frame is returned}

\item{skip_init_calc}{don't use \code{$MAIN} to calculate initial conditions}

\item{simcall}{not used; only the default value of 0 is allowed}
}
\description{
Use the function when you would usually use \code{\link{mrgsim_d}}, 
but you need a quicker turnaround time.  The timing differences 
might be difficult to detect for a single simulation run
but could become appreciable with repeated simulation.  See
\code{details} for important differences in how \code{\link{mrgsim_q}}
is invoked compared to \code{\link{mrgsim}} and \code{\link{mrgsim_d}}.  
This function should always be used for benchmarking simulation time with
mrgsolve.
}
\details{
This function does not support the piped simulation workflow.  All
arguments must be passed into the function except for \code{x}.  

A data set is required for this simulation workflow.  The 
data set can have only dosing records or doses with observations.
When the data set only includes doses, a single numeric vector of 
observation times should be passed in.  

This simulation workflow does not support \code{Req} (request) 
functionality.  All compartments and captured variables will 
always be returned in the simulation output.

This simulation workflow does not support carry-out functionality.

This simulation workflow does not accept arguments to be passed
to \code{\link[mrgsolve]{update}}. This must be done by a separate
call to \code{\link[mrgsolve]{update}}.

This simulation workflow does not support use of event objects.  If 
an event object is needed, it should be converted to a data set 
prior to the simulation run (see \code{as_data_set} or 
\code{\link{as.data.frame.ev}}.

This simulation workflow does not support idata sets or any 
feature enabled by idata set use.  Individual level parameters
should be joined onto the data set prior to simulation.  Otherwise
\code{\link{mrgsim_i}} or \code{\link{mrgsim_ei}} should be used.

By default, a mrgsims object is returned (as with \code{\link{mrgsim}}). 
Use the \code{output="df"} argument to request a plain 
data.frame of simulated data on return.
}
\examples{

mod <- mrgsolve:::house()

data <- expand.ev(amt = c(100,300,1000))

out <- mrgsim_q(mod,data)

out

}
\seealso{
\code{\link{mrgsim}}, \code{\link{mrgsim_variants}}, \code{\link{qsim}}
}
