% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrgsims.R
\name{plot_sims}
\alias{plot_sims}
\title{Plot data as an mrgsims object}
\usage{
plot_sims(.data, ..., .f = NULL, .dots = list())
}
\arguments{
\item{.data}{a data frame}

\item{...}{unquoted column names to plot on y-axis}

\item{.f}{a formula to plot}

\item{.dots}{extra arguments passed to \code{lattice::xyplot}}
}
\description{
Plot data as an mrgsims object
}
\details{
This function is only intended for use with data frames that 
were created by modifying an \code{mrgsims} object.
}
\examples{

mod <- mrgsolve:::house() \%>\% ev(amt = 100)

out <- mrgsim(mod) 
out_df <- dplyr::mutate(out, time <= 72)

plot(out)
plot_sims(out, CP, RESP)

\dontrun{
plot_sims(out, .f = ~ CP + RESP)
plot_sims(out, .f = CP + RESP ~ time)
}

}
