library(msigdbr)
context("functions")

species = msigdbr_show_species()
expect_type(species, "character")
expect_gt(length(species), 5)
expect_match(species, "Homo sapiens", fixed = TRUE, all = FALSE)
expect_match(species, "Mus musculus", fixed = TRUE, all = FALSE)
expect_match(species, "Drosophila melanogaster", fixed = TRUE, all = FALSE)

msigdbr_hs = msigdbr()
expect_s3_class(msigdbr_hs, "tbl_df")
expect_gt(nrow(msigdbr_hs), 100000)

msigdbr_mm = msigdbr(species = "Mus musculus")
expect_s3_class(msigdbr_mm, "tbl_df")
expect_gt(nrow(msigdbr_mm), 100000)

msigdbr_hs_h = msigdbr(species = "Homo sapiens", category = "H")
expect_s3_class(msigdbr_hs_h, "tbl_df")
expect_gt(nrow(msigdbr_hs_h), 5000)
expect_equal(length(unique(msigdbr_hs_h$gs_id)), 50)

msigdbr_mm_h = msigdbr(species = "Mus musculus", category = "H")
expect_s3_class(msigdbr_mm_h, "tbl_df")
expect_gt(nrow(msigdbr_mm_h), 5000)
expect_equal(length(unique(msigdbr_mm_h$gs_id)), 50)

msigdbr_hs_cgp = msigdbr(species = "Homo sapiens", category = "C2", subcategory = "CGP")
expect_s3_class(msigdbr_hs_cgp, "tbl_df")
expect_gt(nrow(msigdbr_hs_cgp), 100000)
expect_gt(length(unique(msigdbr_hs_cgp$gs_id)), 3000)
expect_lt(length(unique(msigdbr_hs_cgp$gs_id)), 5000)

msigdbr_hs_bp = msigdbr(species = "Homo sapiens", category = "C5", subcategory = "BP")
expect_s3_class(msigdbr_hs_bp, "tbl_df")
expect_gt(nrow(msigdbr_hs_bp), 100000)
expect_gt(length(unique(msigdbr_hs_bp$gs_id)), 5000)
expect_lt(length(unique(msigdbr_hs_bp$gs_id)), 10000)

msigdbr_rn_bp = msigdbr(species = "Rattus norvegicus", category = "C5", subcategory = "BP")
expect_s3_class(msigdbr_rn_bp, "tbl_df")
expect_gt(nrow(msigdbr_rn_bp), 100000)
expect_gt(length(unique(msigdbr_rn_bp$gs_id)), 5000)
expect_lt(length(unique(msigdbr_rn_bp$gs_id)), 10000)

expect_error(msigdbr(species = "test"))
expect_error(msigdbr(species = c("Homo sapiens", "Mus musculus")))
expect_error(msigdbr(species = "Homo sapiens", category = c("C1", "C2")))
expect_error(msigdbr(species = "Homo sapiens", category = "C2", subcategory = c("CGP", "CP")))
