% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\docType{data}
\name{returns}
\alias{returns}
\title{Returns of the closing prices of three financial indexes}
\format{
A data frame with 1505 rows and 4 variables:
\describe{
  \item{Date}{a vector indicating the dates of the measurements.}
  \item{COLCAP}{a numeric vector indicating the returns of COLCAP.}
  \item{SP500}{a numeric vector indicating the returns of SP500.}
  \item{BOVESPA}{a numeric vector indicating the returns of BOVESPA.}
}
}
\usage{
data(returns)
}
\description{
These data correspond to the returns of the closing prices of the
Colcap, Bovespa, and S&P 500 indexes from February 2010 to March 2016. Colcap is
a leading indicator of the price dynamics of the 20 most liquid shares on the
Colombian Stock Market. As the newest stock exchange in Latin America, the
Brazilian Stock Exchange has been in existence since 2008 when the stock exchange
of Sao Paulo joined the Stock Exchange and Futures. This is the largest market
in Latin America and one of the largest in the world. Finally, the Standard & Poor's
index is a stock index based on the 500 largest companies in the United States.
}
\examples{
data(returns)
dev.new()
plot(ts(as.matrix(returns[,-1])), main="Returns")

}
\references{
Romero, L.V. and Calderon, S.A. (2021) Bayesian estimation of a multivariate TAR model when the noise
            process follows a Student-t distribution. Communications in Statistics - Theory and Methods, 50, 2508-2530.
}
\keyword{datasets}
