% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_timerelated2.R
\name{time_plot_event}
\alias{time_plot_event}
\title{Plot labeled events}
\usage{
time_plot_event(dt, xlab = "Time", anchor = TRUE, compact = FALSE)
}
\arguments{
\item{dt}{a \code{data.frame} with the following columns
\itemize{
  \item{id}{for ID of each group}
  \item{\code{idn}}{for order of ID}
  \item{start}{for starting time}
  \item{end}{for ending time with arrow head}
  \item{label}{for labeling the starting time}
  \item{\code{labelend}}{for labeling the ending time of a interval}
  \item{type}{for event type as one of p (point), i (interval), b (box)}
  \item{color}{a string for event color}
}}

\item{xlab}{A string for the x-axis title}

\item{anchor}{A Boolean value for the vertical lines linking \code{start} to the x-axis}

\item{compact}{A Boolean value for reducing the vertical spacing when applicable}
}
\value{
a plot
}
\description{
Create a plot for events with labels
}
\examples{
library(ggplot2)
dt = data.frame( id=paste('member',c(rep(c(1,2,3),each=3),3),sep=""),
idn=c(rep(1,3),rep(-1,3), rep(2,4)),
start=1800*c(0,1,2, 0.5, 1.2, 3, 1,2,3,4),
end=1800*c(2,NA,3, 2, 6, NA, 2,2.5,3, 3.5),
label=c(paste('event-',seq(1,10),sep='')),
labelend=c('','','?',')','','','','','>','X'),
type=c('b', 'p', 'i','i','p','p','p','b','i','i' ),
color=c('stove', 'oven', 'oven','oven','stove','oven','oven','other','stove','oven' )
 )
time_plot_event( dt )

}
