% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiblock_results.R
\name{multiblock_results}
\alias{multiblock_results}
\alias{scores.multiblock}
\alias{loadings.multiblock}
\alias{print.multiblock}
\alias{summary.multiblock}
\title{Result Functions for Multiblock Objects}
\usage{
\method{scores}{multiblock}(object, block = 0, ...)

\method{loadings}{multiblock}(object, block = 0, ...)

\method{print}{multiblock}(x, ...)

\method{summary}{multiblock}(object, ...)
}
\arguments{
\item{object}{\code{multiblock} object.}

\item{block}{\code{integer/character} for block selection.}

\item{...}{Not implemented.}

\item{x}{\code{multiblock} object.}
}
\value{
Scores or loadings are returned by \code{scores.multiblock} and \code{loadings.multiblock}, while print and summary methods invisibly returns the object.
}
\description{
Standard result computation and extraction functions for \code{multiblock} objects.
}
\details{
Usage of the functions are shown using generics in the examples below.
Object printing and summary are available through:
\code{print.multiblock} and \code{summary.multiblock}.
Scores and loadings have their own extensions of \code{scores()} and \code{loadings()} throught
\code{scores.multiblock} and \code{loadings.multiblock}.
}
\examples{
data(wine)
sc <- sca(wine[c('Smell at rest', 'View', 'Smell after shaking')], ncomp = 4)
print(sc)
head(loadings(sc, block = 1))

}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for plotting are found in \code{\link{multiblock_plots}}, respectively.
}
