% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{priors}
\alias{priors}
\alias{normal}
\alias{half_normal}
\alias{log_normal}
\alias{cauchy}
\alias{half_cauchy}
\alias{student_t}
\alias{half_student_t}
\alias{log_student_t}
\alias{exponential}
\alias{flat}
\title{Prior distributions}
\usage{
normal(location = 0, scale)

half_normal(scale)

log_normal(location, scale)

cauchy(location = 0, scale)

half_cauchy(scale)

student_t(location = 0, scale, df)

half_student_t(scale, df)

log_student_t(location, scale, df)

exponential(scale = 1/rate, rate = 1/scale)

flat()
}
\arguments{
\item{location}{Prior location. Typically prior mean (see details).}

\item{scale}{Prior scale. Typically prior standard deviation (see details).}

\item{df}{Prior degrees of freedom.}

\item{rate}{Prior rate.}
}
\value{
Object of class \link{nma_prior}.
}
\description{
These functions are used to specify prior distributions for the model parameters.
}
\details{
The \code{location} and \code{scale} parameters are typically the prior mean
and standard deviation, with the following exceptions:
\itemize{
\item For the Cauchy distribution \code{location} is the prior median and
\code{scale} is the prior scale.
\item For the log-Normal distribution, \code{location} and \code{scale} are the prior
mean and standard deviation of the logarithm.
}
\subsection{Compatibility with model parameters}{

The following table summarises which prior distributions may be used with
which model parameters. Essentially, priors that take only non-negative
values (e.g. half-Normal) may only be used for non-negative parameters
(heterogeneity SD/variance/precision, and any auxiliary parameter). If a
real-valued prior distribution is specified for a non-negative parameter, it
will be truncated at 0 to be non-negative.\tabular{lccccc}{
    \tab \strong{Intercept} \code{prior_intercept} \tab \strong{Treatment effects} \code{prior_trt} \tab \strong{Heterogeneity} \code{prior_het} \tab \strong{Regression coefficients} \code{prior_reg} \tab \strong{Auxiliary parameter} \code{prior_aux} \cr
   \strong{Normal} \code{normal()} \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \cr
   \strong{half-Normal} \code{half_normal()} \tab - \tab - \tab Yes \tab - \tab Yes \cr
   \strong{log-Normal} \code{log_normal()} \tab - \tab - \tab Yes \tab - \tab Yes \cr
   \strong{Cauchy }\code{cauchy()} \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \cr
   \strong{half-Cauchy} \code{half_cauchy()} \tab - \tab - \tab Yes \tab - \tab Yes \cr
   \strong{Student t} \code{student_t()} \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \cr
   \strong{half-Student t} \code{half_student_t()} \tab - \tab - \tab Yes \tab - \tab Yes \cr
   \strong{log-Student t} \code{log_student_t()} \tab - \tab - \tab Yes \tab - \tab Yes \cr
   \strong{Exponential} \code{exponential()} \tab - \tab - \tab Yes \tab - \tab Yes \cr
   \strong{Flat} \code{flat()} \tab Yes \tab Yes \tab Yes \tab Yes \tab Yes \cr
}


The \code{flat()} prior is a special case where no prior information is added to
the model, resulting in an implicit flat uniform prior distribution over the
entire support for a parameter. This will be an improper prior if the
parameter is unbounded, and is not generally advised. See the
\href{https://mc-stan.org/docs/stan-users-guide/some-differences-in-the-statistical-models-that-are-allowed.html}{Stan user's guide}
for more details.
}
}
\seealso{
\code{\link[=summary.nma_prior]{summary.nma_prior()}} for summarising details of prior
distributions. \code{\link[=plot_prior_posterior]{plot_prior_posterior()}} for plots comparing the prior and
posterior distributions of model parameters.
}
