% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize-pipeline.R
\name{create_blueprint_graph}
\alias{create_blueprint_graph}
\title{Create a Analysis Pipeline diagram}
\usage{
create_blueprint_graph(
  .pipeline,
  splines = "line",
  render = TRUE,
  show_code = FALSE,
  ...
)
}
\arguments{
\item{.pipeline}{a \code{data.frame} produced by calling a series of add_*
functions.}

\item{splines}{options for how to draw edges (lines) for a grViz diagram}

\item{render}{whether to render the graph or just output grViz code}

\item{show_code}{whether to show the code that generated the diagram}

\item{...}{additional options passed to \code{DiagrammeR::grViz()}}
}
\value{
grViz graph of your pipeline
}
\description{
Create a Analysis Pipeline diagram
}
\examples{
library(tidyverse)
library(multitool)

# create some data
the_data <-
  data.frame(
    id  = 1:500,
    iv1 = rnorm(500),
    iv2 = rnorm(500),
    iv3 = rnorm(500),
    mod = rnorm(500),
    dv1 = rnorm(500),
    dv2 = rnorm(500),
    include1 = rbinom(500, size = 1, prob = .1),
    include2 = sample(1:3, size = 500, replace = TRUE),
    include3 = rnorm(500)
  )

# create a pipeline blueprint
full_pipeline <-
  the_data |>
  add_filters(include1 == 0, include2 != 3, scale(include3) > -2.5) |>
  add_variables(var_group = "ivs", iv1, iv2, iv3) |>
  add_variables(var_group = "dvs", dv1, dv2) |>
  add_model("linear model", lm({dvs} ~ {ivs} * mod))

create_blueprint_graph(full_pipeline)
}
