% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{msTrans_dif}
\alias{msTrans_dif}
\title{Multiscale delta method}
\usage{
msTrans_dif(dta, model = "const", model_par = list(NULL), agg_by = month,
  wet_int_thr = 0.1, maxiter = 10, tol = 1e-04, period = c("G1", "Y1",
  "M1", "D1"), qstep = 0.001)
}
\arguments{
\item{dta}{List with components \code{FROM} (simulated data for the control period), \code{TO} (simulated data for the scenario period) and \code{NEWDATA} (observed data to be transformed). Each component is a \code{data.table} with columns \code{DTM} (date) and the climate variables (typically \code{PR} - precipitation and \code{TAS} - temperature)}

\item{model}{One of \code{loess}, \code{const}, \code{identity}, \code{lm}, \code{smooth}, \code{runmed}, \code{smooth.spline}. The model is used to provide statistical summary of the empirical cumulative distribution function.}

\item{model_par}{optional parameters of the \code{model}}

\item{agg_by}{Function for specification of the period (season, month) to be additionaly included in output, see Details}

\item{wet_int_thr}{Numeric value specifying the minimum depth to be considered wet}

\item{maxiter}{Maximum number of iterations, see Details}

\item{tol}{Stoping criterion of the iteration cycle, see Details}

\item{period}{Specification of the aggregation lengths the correction is applied at with `D` - day(s), `M` - month(s), `Y` - year(s) and `G1` - the overall mean}

\item{qstep}{A numeric value between 0 and 1. The ecdf is calculated only for the quantiles defined by quantile(0, 1, probs = seq(0, 1, by = qstep).}
}
\value{
transformed data.table
}
\description{
Transforms observed data such that the changes in summary statistics of variables at custom time scales are similar to those obtained from climate model simulation. Number of functions can be used to summarize the variables.
}
\examples{
data("basin_PT")
scen = basin_PT$sim_scen
ctrl = basin_PT$sim_ctrl
obs = basin_PT$obs_ctrl
dta = list(TO = scen, FROM = ctrl, NEWDATA = obs)
\dontrun{
msTrans_dif(dta,  maxiter = 10, period = 'D1')
}
}
\references{
Hanel, M., Kozin, R., 2016. Bias and projected changes in climate model simulations at multiple time scales: consequences for hydrological impact assessment. Environmental Modelling and Software, submitted.
}

