\name{simulate_clustered_phylogeny}
\alias{simulate_clustered_phylogeny}
\title{
Simulate a phylogenetic tree with a specified number of clades.
}
\description{
Simulate a phylogenetic tree that has a given number of clades, each
with a given number of tips.
}
\usage{
simulate_clustered_phylogeny(v_sizeclusts, joining_branchlengths = NULL, 
f_simclustphyl = "sim.bd.taxa_Yule1", joiningphyl = NULL, 
b_change_joining_branches = FALSE, ...)
}
\arguments{
    \item{v_sizeclusts}{A vector with the sizes of the clades/clusters.}
    \item{joining_branchlengths}{Default \code{NULL}, if \code{joiningphyl} is \code{NULL}, 
    then has to be provided. A vector of two numbers. The first element are the lenghts of the 
    branches of the cluster joining phylogeny leading to the clusters. The second element will be the 
    lengths of the "internal" branches of the cluster joining phylogeny. If only a single number is provided, 
    then all the branches of the joining phylogeny will have their lengths equal to this value.}
    \item{f_simclustphyl}{What function to use to simulate the phylogeny inside each cluster. 
    The default value of "sim.bd.taxa_Yule1" corresponds to a pure birth tree generated by
    \code{TreeSim::sim.bd.taxa(n=clade_size,numbsim=1,lambda=1,mu=0)[[1]]}, without the root branch
    otherwise the user should pass an object of class \code{function} and its parameters in place of the 
    \code{...} . The first parameter must be the number of contemporary leaves and be called \code{n}.
    The function has to return a valid \code{phylo} object.}
    \item{joiningphyl}{By what phylogeny are the clades to be joined by. Either \code{NULL} (default), 
    a \code{phylo} object, the character string \code{"sim.bd.taxa_Yule1"} or an object of class \code{function}. 
    If \code{NULL}, then they are joined by a caterpillar (comb/pectinate) phylogeny with the branch lengths as 
    provided by the \code{joining_branchlengths} parameter. If it is a \code{phylo} object, 
    then they will be joined by it. Importantly the number of tips of this phylogeny has to equal the number 
    of clusters. If \code{"sim.bd.taxa_Yule1"},  then the joining phylogeny is simulated as a pure birth tree with 
    tips equalling the number of clusters by \code{TreeSim::sim.bd.taxa()}. If it is a function, then this is 
    used and its parameters are passed through \code{...} . The first parameter must be the number of 
    contemporary leaves and be called \code{n}. The function has to return a valid \code{phylo} object.}
    \item{b_change_joining_branches}{Logical, if joining phylogeny (parameter \code{joiningphyl}) was provided or 
    simulated, should its branches be changed according to what was provided in \code{joining_branchlengths} 
    (if it was not \code{NULL}). By default \code{FALSE} and the branch lengths are not changed.}
    \item{...}{Parameters to be passed to user provided \code{f_simclustphyl} and \code{joiningphyl} functions. 
    Unless one knows exactly what one is doing they should be passed by name. If there is a conflict of names, 
    then one should pass wrapper functions around these functions where the names conflict is resolved.}
}

\value{
The resulting object is a \code{clustered_phylo} object which inherits from the \code{phylo} class and enhances it. 
Apart from the standard \code{phylo} fields it has two additional ones:
\itemize{
    \item{edges_clusters}{a named list with length equalling the number of clades/clusters plus 1. The first element
	of the list is called \code{joining_tree} and contains the indices (row numbers of the \code{edge} matrix, 
	indices of the \code{edge_length} vector) of the edges inside the subtree joining the clusters. 
	Afterwords element (i+1) is named cluster_i and contains a numeric vector with the indices of the edges 
	inside clade i.}
    \item{tips_clusters}{a named list with length equalling the number of clades/clusters. Each field of the list 
    is a numeric vector containing the indices of the tips inside the clade. The names of element i of the list 
    is cluster_i.}
}
}
\author{Krzysztof Bartoszek}

\examples{
## i takze ultrametryzacje

RNGversion(min(as.character(getRversion()),"3.6.1"))
set.seed(12345, kind = "Mersenne-Twister", normal.kind = "Inversion")
## We need a wrapper function as TreeSim::sim.bd.taxa returns a list of phylo objects and not 
## a single phylo object
my_sim.bd.taxa<-function(n,...){
    TreeSim::sim.bd.taxa(n=n,...)[[1]]
}
phyltree1<-simulate_clustered_phylogeny(v_sizeclusts=c(5,5,5),f_simclustphyl=my_sim.bd.taxa,
b_change_joining_branches=TRUE, joining_branchlengths=c(20,NA),joining=my_sim.bd.taxa,
numbsim=1,lambda=1,mu=0)

RNGversion(min(as.character(getRversion()),"3.6.1"))
set.seed(12345, kind = "Mersenne-Twister", normal.kind = "Inversion")
## The below code should return the same tree as above
phyltree2<-simulate_clustered_phylogeny(v_sizeclusts=c(5,5,5),f_simclustphyl="sim.bd.taxa_Yule1",
b_change_joining_branches=TRUE, joining_branchlengths=c(20,NA),joining="sim.bd.taxa_Yule1")

## The resulting phylogeny is not ultrametric, if ultrametricity is required, then some procedure 
## has to be employed, e.g.
## phyltree1_u<-phytools::force.ultrametric(phyltree1, method="extend")
RNGversion(as.character(getRversion()))
}
\keyword{models}
\keyword{datagen}
