% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_branch.R
\name{add_filter_branch}
\alias{add_filter_branch}
\alias{add_filter_branch.mverse}
\title{Add filter branches to a \code{mverse} object.}
\usage{
add_filter_branch(.mverse, ...)

\method{add_filter_branch}{mverse}(.mverse, ...)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}

\item{...}{\code{filter_branch} objects.}
}
\value{
The resulting \code{mverse} object.
}
\description{
This method adds one or more filter branches to
an existing \code{mverse} object. Filter branches
are used to define options for conditions
for selecting subsets of data rows.
}
\examples{
# Define a filter branch.
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  !Name \%in\% c("Katrina"),
  !Name \%in\% c("Katrina"),
  TRUE # include all
)
# Create a mverse and add the branch.
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers)
}
\seealso{
Other filter branch functions: 
\code{\link{filter_branch}()}
}
\concept{filter branch functions}
