% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairs.mvgam.R
\name{pairs.mvgam}
\alias{pairs.mvgam}
\title{Create a matrix of output plots from a \code{mvgam} object}
\usage{
\method{pairs}{mvgam}(x, variable = NULL, regex = FALSE, use_alias = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{mvgam}}

\item{variable}{Names of the variables (parameters) to plot, as given by a
character vector or a regular expression (if \code{regex = TRUE}). By
default, a hopefully not too large selection of variables is plotted.}

\item{regex}{Logical; Indicates whether \code{variable} should
be treated as regular expressions. Defaults to \code{FALSE}.}

\item{use_alias}{Logical. If more informative names for parameters are available
(i.e. for beta coefficients \code{b} or for smoothing parameters \code{rho}), replace the uninformative
names with the more informative alias. Defaults to \code{TRUE}}

\item{...}{Further arguments to be passed to
\code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.}
}
\value{
Plottable objects whose classes depend on the arguments supplied.
See \code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}} for details.
}
\description{
A \code{\link[graphics:pairs]{pairs}}
method that is customized for MCMC output.
}
\details{
For a detailed description see
\code{\link[bayesplot:MCMC-scatterplots]{mcmc_pairs}}.
}
\examples{
\dontrun{
simdat <- sim_mvgam(n_series = 1, trend_model = 'AR1')
mod <- mvgam(y ~ s(season, bs = 'cc'),
             trend_model = AR(),
             data = simdat$data_train,
             chains = 2)
pairs(mod)
pairs(mod, variable = c('ar1', 'sigma'), regex = TRUE)
}

}
