% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{theoreticalEta}
\alias{theoreticalEta}
\title{Find optimal theoretical Eta}
\usage{
theoreticalEta(alpha, blur, G, sigma)
}
\arguments{
\item{alpha}{A numeric vector, with m elements, specifying the level of long memory for the noise process within each channel of the form alpha = 2 - 2H, where H is the Hurst parameter. If alpha is a single element, that same element is repeated across all required channels.}

\item{blur}{A character string that specifies the behaviour of the blur function \itemize{
\item 'direct': No blur or direct model is used.
\item 'smooth': Blur that has smooth decay in the Fourier domain.
\item 'box.car': Blur that is of box.car type.
}}

\item{G}{The input blur matrix}

\item{sigma}{A numeric vector with m elements that specifies the level of noise (standard deviation) in each channel. The default method uses the Median Absolute Deviation of wavelet coefficients in the finest resolution (see \code{\link{multiSigma}}) for details.}
}
\value{
The theoretical eta (smoothing parameter) to be used in the thresholding.
}
\description{
Finds the optimal theoretical smoothing paramter for the thresholding
}
\details{
The theory (see Kulik, Sapatinas and Wishart (2014)) suggests that the optimal smoothing parameter depends on the best channel in the smooth blur case while depends on the level of dependence in the box.car blur case. This function finds the theoretically best eta from the data suggested by the theory in that paper.
}
\references{
Kulik, R., Sapatinas, T. and Wishart, J.R. (2014) \emph{Multichannel wavelet deconvolution with long range dependence. Upper bounds on the L_p risk}  Appl. Comput. Harmon. Anal. (to appear in).
\url{http://dx.doi.org/10.1016/j.acha.2014.04.004}
}

