% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_fpca_scores.R
\name{extract_fpca_scores}
\alias{extract_fpca_scores}
\title{Extract FPCA scores}
\usage{
extract_fpca_scores(mxFDAobject, what)
}
\arguments{
\item{mxFDAobject}{object of class \code{mxFDA}}

\item{what}{what functional PCA data to extract, e.g. 'uni k'}
}
\value{
fpca object
}
\description{
Extract FPCA scores
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
#load ovarian mxFDA object
data('ovarian_FDA')

#run ghe lfcm model
ovarian_FDA = run_fpca(ovarian_FDA, metric = "uni g", r = "r",
                       value = "fundiff",
                       analysis_vars = c("age", "survival_time"))

#extract uni fpc scores
fpc = extract_fpca_scores(ovarian_FDA, 'uni g fpca')

}
\author{
Alex Soupir \email{alex.soupir@moffitt.org}
}
