% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-x-table.R
\name{miss_var_table}
\alias{miss_var_table}
\title{Tabulate the missings in the variables}
\usage{
miss_var_table(data)
}
\arguments{
\item{data}{a dataframe}
}
\value{
a dataframe
}
\description{
Provide a tidy table of the number of variables with 0, 1, 2, up to n,
missing values and the proportion of the number of variables those
variables make up.
}
\examples{

miss_var_table(airquality)

library(dplyr)
airquality \%>\%
  group_by(Month) \%>\%
  miss_var_table()

}
\seealso{
\code{\link[=pct_miss_case]{pct_miss_case()}} \code{\link[=prop_miss_case]{prop_miss_case()}} \code{\link[=pct_miss_var]{pct_miss_var()}} \code{\link[=prop_miss_var]{prop_miss_var()}} \code{\link[=pct_complete_case]{pct_complete_case()}} \code{\link[=prop_complete_case]{prop_complete_case()}} \code{\link[=pct_complete_var]{pct_complete_var()}} \code{\link[=prop_complete_var]{prop_complete_var()}} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \url{miss_case_summary} \url{miss_case_table} \url{miss_summary} \url{miss_var_prop} \url{miss_var_run} \url{miss_var_span} \url{miss_var_summary} \url{miss_var_table} \url{n_complete} \url{n_complete_row} \url{n_miss} \url{n_miss_row} \url{pct_complete} \url{pct_miss} \url{prop_complete} \url{prop_complete_row} \url{prop_miss}
}
