% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{rotate_dimensions}
\alias{rotate_dimensions}
\alias{rotate_dimensions,spec_tbl_df-method}
\alias{rotate_dimensions,tbl_df-method}
\title{Rotate two dimensions (e.g., principal components) of an arbitrary angle}
\usage{
rotate_dimensions(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element,
  of_elements = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL,
  action = "add"
)

\S4method{rotate_dimensions}{spec_tbl_df}(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element,
  of_elements = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL,
  action = "add"
)

\S4method{rotate_dimensions}{tbl_df}(
  .data,
  dimension_1_column,
  dimension_2_column,
  rotation_degrees,
  .element,
  of_elements = TRUE,
  dimension_1_column_rotated = NULL,
  dimension_2_column_rotated = NULL,
  action = "add"
)
}
\arguments{
\item{.data}{A `tbl` formatted as | <element> | <feature> | <value> | <...> |}

\item{dimension_1_column}{A character string. The column of the dimension 1}

\item{dimension_2_column}{A character string. The column of the dimension 2}

\item{rotation_degrees}{A real number between 0 and 360}

\item{.element}{The name of the element column (normally elements).}

\item{of_elements}{A boolean. In case the input is a nanny object, it indicates Whether the element column will be element or feature column}

\item{dimension_1_column_rotated}{A character string. The column of the rotated dimension 1 (optional)}

\item{dimension_2_column_rotated}{A character string. The column of the rotated dimension 2 (optional)}

\item{action}{A character string. Whether to join the new information to the input tbl (add), or just get the non-redundant tbl with the new information (get).}
}
\value{
A tbl object with additional columns for the reduced dimensions. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.

A tbl object with additional columns for the reduced dimensions. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.

A tbl object with additional columns for the reduced dimensions. additional columns for the rotated dimensions. The rotated dimensions will be added to the original data set as `<NAME OF DIMENSION> rotated <ANGLE>` by default, or as specified in the input arguments.
}
\description{
rotate_dimensions() takes as imput a `tbl` formatted as | <DIMENSION 1> | <DIMENSION 2> | <...> | and calculates the rotated dimensional space of the feature value.
}
\details{
\lifecycle{maturing}

This function to rotate two dimensions such as the reduced dimensions.
}
\examples{

 mtcars_tidy_MDS = reduce_dimensions(mtcars_tidy, car_model, feature, value, method="MDS")
 
 rotate_dimensions(mtcars_tidy_MDS, `Dim1`, `Dim2`, .element = car_model, rotation_degrees = 45)


}
