% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{nng_error}
\alias{nng_error}
\title{Translate Error Codes}
\usage{
nng_error(xc)
}
\arguments{
\item{xc}{integer exit code to translate.}
}
\value{
A character vector.
}
\description{
Translate integer exit code to human readable form. All package functions
    return an integer exit code on error rather than the expected return
    value. These are classed 'errorValue' and may be checked by the function
    \code{\link{is_error_value}}.
}
\section{Warnings}{


    A warning is generated every time an 'errorValue' is returned.

    \code{\link{nano_init}} may be used to set the value of option 'warn' and
    automatically reverts it upon package unload. The default, applied by
    calling \code{nano_init()} with no arguments, is 'immediate', which prints
    warnings as they occur.

    Further options for warnings may be set manually via \code{\link{options}}:

    \itemize{

    \item{warning.expression} { - an R code expression to be called if a
    warning is
    generated, replacing the standard message. If non-null it is called
    irrespective of the value of option warn.}

    \item{warning.length} { - sets the truncation limit in bytes for error and warning
    messages. A non-negative integer, with allowed values 100...8170, default
    1000.}

    \item{nwarnings} { - the limit for the number of warnings kept when warn = 0,
    default 50. This will discard messages if called whilst they are being
    collected. If you increase this limit, be aware that the current
    implementation pre-allocates the equivalent of a named list for them.}
    }
}

\examples{
nng_error(1L)

}
