% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calc_prob_mat}
\alias{calc_prob_mat}
\title{Calculate probability matrix from distances and dot products between neuron
segments}
\usage{
calc_prob_mat(nndists, dotprods, distbreaks, dotprodbreaks = seq(0, 1, by =
  0.1), ReturnCounts = FALSE)
}
\arguments{
\item{nndists}{a list of nearest-neighbour distances or a list of both
nearest-neighbour distances and dot products.}

\item{dotprods}{a list of dot products.}

\item{distbreaks}{a vector specifying the breaks for distances in the
probability matrix.}

\item{dotprodbreaks}{a vector specifying the breaks for dot products in the
probability matrix.}

\item{ReturnCounts}{a Boolean indicating that counts should be returned
  instead of the default probabilities.}
}
\value{
A matrix with columns as specified by \code{dotprodbreaks} and rows
  as specified by \code{distbreaks}, containing probabilities (for default
  value of \code{ReturnCounts=TRUE}) or counts (if \code{ReturnCounts=TRUE})
  for finding neuron segments with the given distance and dot product.
}
\description{
Calculate probability matrix from distances and dot products between neuron
segments
}

