% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/neuronlist_interactive_3d.R
\name{find.soma}
\alias{find.soma}
\title{Find neurons with soma inside 3d selection box (usually drawn in rgl window)}
\usage{
find.soma(sel3dfun = select3d(), indices = names(db),
  db = getOption("nat.default.neuronlist"), invert = FALSE)
}
\arguments{
\item{sel3dfun}{A \code{\link{select3d}} style function to indicate if points
are within region}

\item{indices}{Names of neurons to search (defaults to all neurons in list)}

\item{db}{\code{neuronlist} to search. Can also be a character vector naming
the neuronlist. Defaults to \code{options('nat.default.neuronlist')}.}

\item{invert}{Whether to return neurons outside the selection box (default
\code{FALSE})}
}
\value{
Character vector of names of selected neurons
}
\description{
Find neurons with soma inside 3d selection box (usually drawn in rgl window)
}
\details{
Can work on \code{neuronlist}s containing \code{neuron} objects
  \emph{or} \code{neuronlist}s whose attached data.frame contains soma
  positions specified in columns called X,Y,Z  .
}
\seealso{
\code{\link{select3d}, \link{subset.neuronlist}, \link{find.neuron}}
}

