% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuronlist.R
\name{neuronlist}
\alias{neuronlist}
\title{Create a neuronlist from zero or more neurons}
\usage{
neuronlist(..., DATAFRAME = NULL)
}
\arguments{
\item{...}{objects to be turned into a list}

\item{DATAFRAME}{an optional \code{data.frame} to attach to the neuronlist 
containing information about each neuron.}
}
\value{
A new neuronlist object.
}
\description{
\code{neuronlist} objects consist of a list of neuron objects 
  (usually of class \code{\link{neuron}} or \code{\link{dotprops}}) along 
  with an optional attached dataframe containing information about the 
  neurons. \code{neuronlist} objects can be indexed using their name or the 
  number of the neuron like a regular list. Both the \code{list} itself and 
  the attached \code{data.frame} must have the same unique (row)names. If the
  \code{[} operator is used to index the list, the attached dataframe will 
  also be subsetted.
  
  It is perfectly acceptable not to pass any parameters, generating an empty 
  neuronlist
}
\examples{
# generate an empty neuronlist
nl=neuronlist()
# slice an existing neuronlist with regular indexing
kcs5=kcs20[1:5]

# extract a single neuron from a neuronlist
n1=Cell07PNs[[1]]

# list all methods for neuronlist objects
methods(class='neuronlist')
}
\seealso{
\code{\link{as.data.frame.neuronlist}}, 
  \code{\link{neuronlist-dataframe-methods}}, \code{\link{neuron}}, 
  \code{\link{dotprops}}

Other neuronlist: \code{\link{*.neuronlist}},
  \code{\link{is.neuronlist}},
  \code{\link{neuronlist-dataframe-methods}},
  \code{\link{neuronlistfh}}, \code{\link{nlapply}},
  \code{\link{read.neurons}}, \code{\link{write.neurons}}
}
