% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xform.R
\name{xyzmatrix}
\alias{xyzmatrix}
\alias{xyzmatrix.default}
\alias{xyzmatrix.dotprops}
\alias{xyzmatrix.hxsurf}
\alias{xyzmatrix.igraph}
\alias{xyzmatrix.mesh3d}
\alias{xyzmatrix.neuron}
\alias{xyzmatrix.neuronlist}
\alias{xyzmatrix<-}
\alias{xyzmatrix<-.dotprops}
\alias{xyzmatrix<-.hxsurf}
\alias{xyzmatrix<-.igraph}
\alias{xyzmatrix<-.neuron}
\alias{xyzmatrix<-.shape3d}
\title{Get and assign coordinates for classes containing 3D vertex data}
\usage{
xyzmatrix(x, ...)

\method{xyzmatrix}{default}(x, y = NULL, z = NULL, ...)

\method{xyzmatrix}{neuron}(x, ...)

\method{xyzmatrix}{neuronlist}(x, ...)

\method{xyzmatrix}{dotprops}(x, ...)

\method{xyzmatrix}{hxsurf}(x, ...)

\method{xyzmatrix}{igraph}(x, ...)

\method{xyzmatrix}{mesh3d}(x, ...)

xyzmatrix(x) <- value

\method{xyzmatrix}{neuron}(x) <- value

\method{xyzmatrix}{dotprops}(x) <- value

\method{xyzmatrix}{hxsurf}(x) <- value

\method{xyzmatrix}{igraph}(x) <- value

\method{xyzmatrix}{shape3d}(x) <- value
}
\arguments{
\item{x}{object containing 3D coordinates}

\item{...}{additional arguments passed to methods}

\item{y, z}{separate y and z coordinates}

\item{value}{Nx3 matrix specifying new xyz coords}
}
\value{
For \code{xyzmatrix}: Nx3 matrix containing 3D coordinates

For \code{xyzmatrix<-}: Original object with modified coords
}
\description{
\code{xyzmatrix} gets coordinates from objects containing 3D vertex data

\code{xyzmatrix<-} assigns xyz elements of neuron or dotprops
  object and can also handle matrix like objects with columns named X, Y, Z
  or x, y, z.
}
\details{
Note that \code{xyzmatrix} can extract or set 3D coordinates in a 
  \code{matrix} or \code{data.frame} that \bold{either} has exactly 3 columns
  \bold{or} has 3 columns named X,Y,Z or x,y,z.
}
\examples{
# see all available methods for different classes
methods('xyzmatrix')
# ... and for the assignment method
methods('xyzmatrix<-')
n=Cell07PNs[[1]]
xyzmatrix(n)<-xyzmatrix(n)
stopifnot(isTRUE(
  all.equal(xyzmatrix(n),xyzmatrix(Cell07PNs[[1]]))
))
}
\seealso{
\code{\link{xyzmatrix}}
}

