% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuron-io.R
\name{read.neurons}
\alias{read.neurons}
\title{Read one or more neurons from file to a neuronlist in memory}
\usage{
read.neurons(paths, pattern = NULL, neuronnames = basename, format = NULL,
  nl = NULL, df = NULL, OmitFailures = TRUE, SortOnUpdate = FALSE, ...)
}
\arguments{
\item{paths}{Paths to neuron input files \emph{or} a directory containing 
neurons \emph{or} a \code{\link{neuronlistfh}} object, \emph{or} a zip 
archive containing multiple neurons.}

\item{pattern}{If paths is a directory, \code{\link[base]{regex}} that file 
names must match.}

\item{neuronnames}{Character vector or function that specifies neuron names. 
See details.}

\item{format}{File format for neuron (see \code{\link{read.neuron}})}

\item{nl}{An existing neuronlist to be updated (see details)}

\item{df}{Optional data frame containing information about each neuron}

\item{OmitFailures}{Omit failures (when TRUE) or leave an NA value in the 
list}

\item{SortOnUpdate}{When \code{nl!=NULL} the resultant neuronlist will be 
sorted so that neurons are ordered according to the value of the 
\code{paths} argument.}

\item{...}{Additional arguements to passed to read.neuron methods}
}
\value{
\code{\link{neuronlist}} object containing the neurons
}
\description{
Read one or more neurons from file to a neuronlist in memory
}
\details{
This function will cope with the same set of file formats offered by
  \code{read.neuron}.
  
  If the \code{paths} argument specifies a (single) directory then all files 
  in that directory will be read unless an optional regex pattern is also 
  specified. Similarly, if \code{paths} specifies a zip archive, all neurons 
  within the archive will be loaded.
  
  \code{neuronnames} must specify a unique set of names that will be used as 
  the names of the neurons in the resultant neuronlist. If \code{neuronnames}
  is a a function then this will be applied to the path to each neuron. The 
  default value is the function \code{basename} which results in each neuron 
  being named for the input file from which it was read.
  
  The optional dataframe (\code{df}) detailing each neuron should have 
  \code{rownames} that match the names of each neuron. It would also make 
  sense if the same key was present in a column of the data frame. If the 
  dataframe contains more rows than neurons, the superfluous rows are dropped
  with a warning. If the dataframe is missing rows for some neurons an error 
  is generated. If SortOnUpdate is TRUE then updating an existing neuronlist 
  should result in a new neuronlist with ordering identical to reading all 
  neurons from scratch.
}
\examples{
\dontrun{
## Read C. elegans neurons from OpenWorm github repository
vds=paste0("VD", 1:13)
vdurls=paste0("https://raw.githubusercontent.com/openworm/CElegansNeuroML/",
  "103d500e066125688aa7ac5eac7e9b2bb4490561/CElegans/generatedNeuroML/",vds,
  ".morph.xml")
vdnl=read.neurons(vdurls, neuronnames=vds)
plot3d(vdnl)

## The same, but this time add some metadata to neuronlist
# fetch table of worm neurons from wormbase
library(rvest)
nlurl="http://wormatlas.org/neurons/Individual\%20Neurons/Neuronframeset.html"
wormneurons = html_table(html(nlurl), fill=TRUE)[[4]]
vddf=subset(wormneurons, Neuron\%in\%vds)
rownames(vddf)=vddf$Neuron
# attach metadata to neuronlist
vdnl=read.neurons(vdurls, neuronnames=vds, df=vddf)
# use metadata to plot a subset of neurons
clear3d()
plot3d(vdnl, grepl("P[1-6].app", Lineage))
}
}
\seealso{
\code{\link{read.neuron}}, \code{\link{write.neurons}},
  \code{\link{fileformats}}

Other neuronlist: \code{\link{*.neuronlist}},
  \code{\link{is.neuronlist}},
  \code{\link{neuronlist-dataframe-methods}},
  \code{\link{neuronlistfh}}, \code{\link{neuronlist}},
  \code{\link{nlapply}}, \code{\link{write.neurons}}
}

