% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomized_rounding_expectation.R
\name{randomized_rounding_expectation}
\alias{randomized_rounding_expectation}
\title{Sample integer solution from linear programming solution with sample sizes correct in expectation}
\usage{
randomized_rounding_expectation(o, N, n_comp)
}
\arguments{
\item{o}{linear programming results, as found in the `o` element of the
returned list from \code{\link{balance_LP}()}.}

\item{N}{the total number of available controls in the data.}
}
\value{
Dataframe with two columns: \code{pr}, which contains
the coefficient determined for that unit from the linear programming
solution, and \code{select}, a boolean vector stating whether that
unit was selected for inclusion by randomized rounding.
}
\description{
The linear programming solution of \code{\link{balance_LP}()} that is used
within \code{\link{optimize_controls}()} sometimes selects fractional control units.
Here, we select any unit the linear programming solution chose with coefficient 1.
Then, we select sample each unit with a fractional solution with
probability equal to the linear programming solution. The total sample
size is then correct in expectation. Used within \code{\link{optimize_controls}()}
if \code{correct_sizes = FALSE}.
}
\keyword{internal}
