% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_qs.R
\name{verify_inputs_EMD}
\alias{verify_inputs_EMD}
\title{Verify the inputs to the earthmover's distance problem}
\usage{
verify_inputs_EMD(ratio, st, z, treated = 1)
}
\arguments{
\item{ratio}{a numeric or vector specifying the desired ratio of controls to `treated` in
each stratum. If there is one control group and all treated units should be included,
this can be a numeric. Otherwise, this should be
a vector with one entry per treatment group, in the same order as the levels of
\code{z}, including the treated level. If \code{NULL}, \code{q_s} should be specified.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{z}{a factor with the \code{i}th entry equal to the treatment of unit \code{i}.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}
}
\value{
No return value. If there is a problem with the inputs to \code{\link{generate_qs}()},
an error is raised.
}
\description{
Check that the ratio, strata, and treated indicator provided to \code{\link{generate_qs}()}
are in the correct forms and that the desired ratio is feasible
across the population.
}
\keyword{internal}
