% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histpop.plot.R
\name{histpop.plot}
\alias{histpop.plot}
\title{Plots population histogram of the NCA metrics selected for model diagnosis.}
\usage{
histpop.plot(obsdata = outData, simdata = smedianData, figlbl = NULL,
  param = c("AUClast", "Cmax"), cunit = NULL, tunit = NULL,
  spread = "npi")
}
\arguments{
\item{obsdata}{Data frame with the values of the NCA metrics estimated from
the observed data}

\item{simdata}{Data frame with the values of the NCA metrics estimated from
the simulated data}

\item{figlbl}{Figure label based on dose identifier and/or population
stratifier (\strong{NULL})}

\item{param}{A character array of the NCA metrics. The allowed NCA metrics 
for this histograms are "AUClast", "AUClower_upper", "AUCINF_obs", 
"AUCINF_pred", "AUMClast", "Cmax", "Tmax" and "HL_Lambda_z". 
(\strong{c("AUClast", "Cmax")})}

\item{cunit}{Unit for concentration (default is \strong{\code{NULL}})}

\item{tunit}{Unit for time (default is \strong{\code{NULL}})}

\item{spread}{Measure of the spread of simulated data (ppi (95\% parametric
prediction interval) or npi (95\% nonparametric prediction interval))
(\strong{"npi"})}
}
\value{
returns a graphical object created by arrangeGrob function
}
\description{
\pkg{histpop.plot} plots population histogram of the NCA metrics selected 
for model diagnosis (e.g. AUClast, AUCINF_obs, Cmax and Tmax).
}
\details{
\pkg{histpop.plot} plots histogram of the NCA metrics selected for the model 
diagnosis and compares with the corresponding metrics estimated from the 
observed data. The allowed NCA metrics for this histograms are "AUClast", 
"AUClower_upper", "AUCINF_obs", "AUCINF_pred", "AUMClast", "Cmax", "Tmax" and
"HL_Lambda_z". By default, this function produces histogram of AUClast and 
Cmax.
}
