% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_08.R
\name{trauma_08}
\alias{trauma_08}
\title{Trauma-08 Calculation}
\usage{
trauma_08(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  esituation_02_col,
  eresponse_05_col,
  transport_disposition_col,
  evitals_06_col,
  evitals_14_col,
  evitals_23_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data with all relevant
columns. Default is \code{NULL}.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{A column specifying unique patient records.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{A column indicating the patient’s age in numeric form.}

\item{epatient_16_col}{A column specifying the unit of patient age (e.g.,
"Years", "Days").}

\item{esituation_02_col}{A column containing information about the nature of
the patient’s condition (e.g., injury type).}

\item{eresponse_05_col}{A column specifying the type of response (e.g., 911
codes).}

\item{transport_disposition_col}{A column specifying transport disposition
for the patient.}

\item{evitals_06_col}{A column containing systolic blood pressure (SBP) data
from initial vital signs.}

\item{evitals_14_col}{A column containing respiratory rate data from initial
vital signs.}

\item{evitals_23_col}{A column containing total Glasgow Coma Scale (GCS)
scores from initial vital signs.}

\item{...}{Additional arguments passed to the \code{summarize_measure} function.}
}
\value{
A tibble summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All, Adults, Peds).
\code{numerator}: Count of incidents where the respiratory rate, SBP, and GCS
vitals were taken.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents where the respiratory rate, SBP, and GCS
vitals were taken.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
This function calculates the Trauma-08 measure, which evaluates the
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_02 = rep("Yes", 5),
    evitals_06 = c(100, 90, 80, 70, 85),
    evitals_14 = c(30, 9, 8, 7, 31),
    evitals_23 = c(6, 7, 8, 8, 7),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

  # Run function with the first and last pain score columns
  trauma_08(
    df = test_data,
    erecord_01_col = erecord_01,
    incident_date_col = NULL,
    patient_DOB_col = NULL,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    esituation_02_col = esituation_02,
    evitals_06_col = evitals_06,
    evitals_14_col = evitals_14,
    evitals_23_col = evitals_23,
    transport_disposition_col = edisposition_30
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
