% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unzipZipfileParallel.R
\name{unzipZipfileParallel}
\alias{unzipZipfileParallel}
\title{Unzip a zip file either at just the top level or recursively through the file}
\usage{
unzipZipfileParallel(
  zippath,
  outpath = substr(zippath, 1, nchar(zippath) - 4),
  level = "all",
  nCores = 1,
  progress = TRUE
)
}
\arguments{
\item{zippath}{The filepath of the input file}

\item{outpath}{The name of the folder to save unpacked files to}

\item{level}{Whether the unzipping should occur only for the 'top' zip file, or unzip 'all' recursively, or only files 'in' the folder specified}

\item{nCores}{Number of cores to use for parallelization}

\item{progress}{T or F, should progress bars be printed?}
}
\description{
Unzip a zip file either at just the top level or recursively through the file
}
\references{
License: GNU AFFERO GENERAL PUBLIC LICENSE Version 3, 19 November 2007
}
\author{
Christine Laney \email{claney@battelleecology.org}
Claire Lunch \email{clunch@battelleecology.org}
}
\keyword{internal}
