% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind}
\alias{bind}
\title{Function to bind objects together into a longer object.}
\usage{
bind(x, ...)
}
\arguments{
\item{x}{An object returned by one of the \code{get_*} commands for download, site or dataset.}

\item{...}{other objects of the same class.}
}
\value{
This command returns a larger list.
}
\description{
From multiple \code{download*}s, \code{dataset*}s or \code{site}s, join them together into a single object.
}
\details{
To support further synthesis and analysis \code{compile_download} works to transform a list
returned by \code{\link{get_download}} into a large data frame with columns for site and sample attributes
and also with the associated assemblage data at each sample depth.  This function also does the same for
single sites.
}
\examples{
\dontrun{
#  Search for sites with "Thuja" pollen that are older than 8kyr BP and
#  that are on the west coast of North America:
t8kyr.poa <- get_dataset(taxonname="Thuja*", 
                         loc=c(-150, 20, -100, 60), ageyoung = 8000)
t8kyr.canis <- get_dataset(taxonname="Canis*", 
                           loc=c(-150, 20, -100, 60), ageyoung = 8000)

t8kyr.co_site <- bind(t8kyr.poa, t8kyr.canis)
plot(t8kyr.co_site)

####
# Download dataset data across four dataset types along the forest prairie boundary:
# We want to look at four different dataset types across a forest prairie boundary:
dataset_types <- c("ostracode surface sample",
                   "water chemistry",
                   "diatom surface sample",
                   "pollen surface sample")

# Run the "get_dataset` function for each of the different dataset types 
dataset_lists <- lapply(dataset_types, 
                          function(x) { 
                            get_dataset(datasettype=x, 
                                        loc = c(-100,43,-92,48))
                                        })

# Using do.call here to make sure that I don"t have to split the list out.
new_datasets <- do.call(bind, dataset_lists)

# And voila!
plot(new_datasets)

}
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
}
\keyword{utilities}

