% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_netcox_cv.R
\name{plot_netcox_cv}
\alias{plot_netcox_cv}
\title{plots for \code{netcox_cv}}
\usage{
plot_netcox_cv(netcox_cv_obj)
}
\arguments{
\item{netcox_cv_obj}{The \code{\link{netcox_cv}} object.}
}
\value{
The plot is the \code{cvm} (red dot) for each lambda with its standard error (vertical bar). The two vertical dashed lines corresponds to the \code{lambda.min} and \code{lambda.1se}
}
\description{
Plot the cross-validation curves produced by \code{\link{netcox_cv}}.
}
\examples{
grp <- matrix(c(0, 0, 0, 0, 0,
                0, 0, 0, 0, 0,
                1, 1, 0, 0, 0,
                0, 0, 0, 0, 0,
                0, 1, 0, 1, 0),
              ncol = 5, byrow = TRUE)
grp.var <- matrix(c(1, 0, 0, 0, 0, #A1
                    1, 0, 0, 0, 0, #A2
                    0, 0, 0, 1, 0, #C1
                    0, 0, 0, 1, 0, #C2
                    0, 1, 0, 0, 0, #B
                    0, 0, 1, 0, 0, #A1B
                    0, 0, 1, 0, 0, #A2B
                    0, 0, 0, 0, 1, #C1B
                    0, 0, 0, 0, 1  #C2B
                   ), ncol = 5, byrow = TRUE)
eta_g <- rep(1, 5)
x <- as.matrix(sim[, c("A1","A2","C1","C2","B",
                       "A1B","A2B","C1B","C2B")])
lam.seq <- 10^seq(0, -2, by = -0.2)

cv <- netcox_cv(x = x,
                ID = sim$Id,
                time = sim$Start,
                time2 = sim$Stop,
                event = sim$Event,
                lambda = lam.seq,
                group = grp,
                group_variable = grp.var,
                penalty_weights = eta_g,
                nfolds = 5,
                tol = 1e-4,
                maxit = 1e3,
                verbose = FALSE)
plot_netcox_cv(cv)               
}
\seealso{
\code{\link{netcox}}, \code{\link{netcox_cv}}.
}
