% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peerprocess.R
\name{peer.process}
\alias{peer.process}
\title{Generate direct transmission process}
\usage{
peer.process(A, max.time = 3, mprob = 0.5, epsilon = 0.3)
}
\arguments{
\item{A}{\code{[n x n]} adjacency matrix.}

\item{max.time}{the maximum discrete time that direct transmission occurs.}

\item{mprob}{the maximum susceptibility probability, i.e. maximum probability that \eqn{i}'s outcome at time \eqn{t} depends on \eqn{i}'s peers at time \eqn{t-1}.}

\item{epsilon}{standard deviation of error process. This adds uncertainties in outcomes.

For t=1,2, ... \code{max.time} :
\deqn{p ~ Unif(0, mprob)}
\deqn{Y^{t}_{i} = Y^t_i=  (1 - p)Y^{t-1}_i + p \sum\limits{j} A_{ij} Y^{t-1}_j / \sum_{j} A_{ij}  +  N(0, \epsilon) }{Y^t_i=  (1 - p)Y^{t-1}_i + p \sum_{j} A_ij Y^{t-1}_j / \sum_{j} A_ij  +  N(0, \epsilon) }}
}
\value{
a list of time-evolving outcomes from \code{time0} to \code{time(max.time)}.
}
\description{
Generate time-evolving outcomes where outcomes at time \eqn{t} of \eqn{i} depends on outcomes of \eqn{i}'s adjacent peers at time \eqn{t-1}.
}
\examples{
library(netdep)
library(igraph)
library(stats)
G = latent.netdep(n.node = 100, rho = 0.2)
A = as.matrix(get.adjacency(G))
outcomes = peer.process(A, max.time = 3, mprob = 0.3, epsilon = 0.5)


}
