% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffnet-methods.r
\name{plot_adopters}
\alias{plot_adopters}
\title{Visualize adopters and cumulative adopters}
\usage{
plot_adopters(obj, freq = FALSE, what = c("adopt", "cumadopt"),
  add = FALSE, include.legend = TRUE, include.grid = TRUE, pch = c(21,
  24), type = c("b", "b"), ylim = if (!freq) c(0, 1) else NULL, lty = c(1,
  1), col = c("black", "black"), bg = c("tomato", "gray"), xlab = "Time",
  ylab = ifelse(freq, "Frequency", "Proportion"),
  main = "Adopters and Cumulative Adopters", ...)
}
\arguments{
\item{obj}{Either a diffnet object or a cumulative a doption matrix.}

\item{freq}{Logical scalar. When TRUE frequencies are plotted instead of proportions.}

\item{what}{Character vector of length 2. What to plot.}

\item{add}{Logical scalar. When TRUE lines and dots are added to the current graph.}

\item{include.legend}{Logical scalar. When TRUE a legend of the graph is plotted.}

\item{include.grid}{Logical scalar. When TRUE, the grid of the graph is drawn}

\item{pch}{Integer vector of length 2. See \code{\link{matplot}}.}

\item{type}{Character vector of length 2. See \code{\link{matplot}}.}

\item{ylim}{Numeric vector of length 2. Sets the plotting limit for the y-axis.}

\item{lty}{Numeric vector of length 2. See \code{\link{matplot}}.}

\item{col}{Character vector of length 2. See \code{\link{matplot}}.}

\item{bg}{Character vector of length 2. See \code{\link{matplot}}.}

\item{xlab}{Character scalar. Name of the x-axis.}

\item{ylab}{Character scalar. Name of the y-axis.}

\item{main}{Character scalar. Title of the plot}

\item{...}{Further arguments passed to \code{\link{matplot}}.}
}
\value{
A matrix as described in \code{\link{cumulative_adopt_count}}.
}
\description{
Visualize adopters and cumulative adopters
}
\examples{
# Generating a random diffnet -----------------------------------------------
set.seed(821)
diffnet <- rdiffnet(100, 5, seed.graph="small-world", seed.nodes="central")

plot_adopters(diffnet)

# Alternatively, we can use a TOA Matrix
toa <- sample(c(NA, 2010L,2015L), 20, TRUE)
mat <- toa_mat(toa)
plot_adopters(mat$cumadopt)
}
\seealso{
Other visualizations: \code{\link{dgr}},
  \code{\link{diffusionMap}}, \code{\link{drawColorKey}},
  \code{\link{grid_distribution}},
  \code{\link{hazard_rate}}, \code{\link{plot_diffnet2}},
  \code{\link{plot_diffnet}},
  \code{\link{plot_infectsuscep}},
  \code{\link{plot_threshold}},
  \code{\link{rescale_vertex_igraph}}
}
\author{
George G. Vega Yon
}
