% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_prediction.R
\name{predict_graph}
\alias{predict_graph}
\title{Predicts a graph from a time series of graphs.}
\usage{
predict_graph(
  graphlist,
  formulation = 2,
  conf_level1 = NULL,
  conf_level2 = 90,
  dense_opt = 2,
  weights_opt = 4,
  weights_param = 0.001,
  h = 1
)
}
\arguments{
\item{graphlist}{A list of graphs in igraph format.}

\item{formulation}{Formulation 2 includes an additional condition constraining total
edges by the predicted value. Formulation 1 does not have that constraint. Formulation 2
gives more realistic graphs due to that constraint. Default is set to \code{2}.}

\item{conf_level1}{A value between 50 and 100 denoting the confidence interval
for the number of predicted nodes in the graph. If set to \code{NULL} the predicted
graph has the mean number of predicted nodes. If set to \code{80} for example,
there would be 3 predicted graphs. One with mean number of predicted nodes, and
the other two with the number of nodes corresponding to lower and upper
confidence bounds.}

\item{conf_level2}{The upper confidence bound for the degree distribution. Default
set to \code{90}.}

\item{dense_opt}{If set to \code{2} the dense option in R package \code{lpSolve}
will be used.}

\item{weights_opt}{Weights option ranging from 1 to 4 used for different edge weight
schemes. Weights option 1 uses uniform weights for all edges. Option 2 uses binary
weights. If the edge existed in a past graph, then weight is set to 1. Else set to
0. All possible new edges are assigned weight 1. Option 3 is a more selective
version. Option 4 is proportional weights according to the history.}

\item{weights_param}{The weight given for possible edges from new vertices. Default
set to \code{0.001}.}

\item{h}{The prediction time step. Default is \code{ h = 1}.}
}
\value{
A list of predicted graphs. If \code{conf_level1} is not \code{NULL}, then
3 graphs are returned one with the mean number of predicted nodes and the other 2
with the number of nodes equal to the lower and upper bound values of prediction.
If If \code{conf_level1} is \code{NULL}, only the mean predicted graph is returned.
}
\description{
This function predicts the graph at a future time step using a time series of
graphs.
}
\examples{
library(igraph)
set.seed(2024)
edge_increase_val <- new_nodes_val <- del_edge_val <- 0.1
graphlist <- list()
graphlist[[1]] <- gr <-  igraph::sample_pa(5, directed = FALSE)
for(i in 2:15){
  gr <-  generate_graph(gr,
                        del_edge = del_edge_val,
                        new_nodes = new_nodes_val,
                        edge_increase = edge_increase_val )
  graphlist[[i]] <- gr
}
grpred <- predict_graph(graphlist[1:15], conf_level2 = 90, weights_opt = 4)
grpred

}
