% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkLite-package.R
\name{networkLite-package}
\alias{networkLite-package}
\title{networkLite Package}
\description{
\tabular{ll}{
Package: \tab networkLite\cr
Type: \tab Package\cr
Version: \tab 1.0.5\cr
Date: \tab 2023-03-10\cr
License: \tab GPL-3\cr
LazyLoad: \tab yes\cr
}
}
\details{
The \code{networkLite} package provides an alternative implementation of
some of the functionality in the \code{network} package, based on a
different data structure that is faster for certain applications. It is
intended for use as a backend data structure in \code{EpiModel} and
\code{statnet} packages, and its implementation is subject to change.

The \code{networkLite} data structure is a named list with three components:
\itemize{
\item \code{el}, a \code{tibble} edgelist, including edge attributes
\item \code{attr}, a \code{tibble} of vertex attributes
\item \code{gal}, a named list of network attributes
}

These components should not be referred to directly by the user in their own
code. Instead, the various access, coercion, etc. methods provided by this
package should be used. See \code{\link{networkLite}} for information on
how to construct a \code{networkLite}.

Certain names in \code{el}, \code{attr}, and \code{gal} have special significance. These are:
\itemize{
\item For \code{el}: \code{".tail"} and \code{".head"}, of class integer, which are the tails and
heads of edges, and must be preserved as atomic integer vectors with no \code{NA}s;
\code{"na"}, which is a logical attribute indicating if the edge is missing or not,
and should take \code{TRUE}/\code{FALSE} values only (behavior for other values is
undefined, and \code{NA}s are not allowed); \code{"na"} may be structured as either an
atomic logical vector or a list.
\item For \code{attr}: \code{"na"}, which is a logical attribute indicating if the vertex is
missing or not, and \code{"vertex.names"}, which provides names for the vertices in
the network; the attribute \code{"na"} should take values \code{TRUE} or \code{FALSE} only
(behavior for other values is undefined).
\item For \code{gal}: \code{"n"} (the network size), \code{"directed"} (a logical indicating if the
network is directed), \code{"bipartite"} (either \code{FALSE} to indicate the network is
not bipartite, or the size of the first bipartition if the network is bipartite),
\code{"hyper"} (a logical indicating if the network is a hypergraph), \code{"multiple"}
(a logical indicating if the network is a multigraph), and \code{"loops"} (a logical
indicating if the network is allowed to have loops).
}

For \code{networkLite}s, the three network attributes \code{"hyper"},
\code{"multiple"}, and \code{"loops"} must all be \code{FALSE}. Even with
these restrictions, \code{networkLite}s do not provide all the functionality
that \code{network}s do, but attempt to offer what is necessary for backend
use in \code{ergm}, \code{tergm}, and \code{EpiModel}.
}
