% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modal.R
\name{modalDialog}
\alias{modalDialog}
\title{Generate a modal box}
\usage{
modalDialog(
  ...,
  title = NULL,
  footer = modalButton("Dismiss"),
  size = c("m", "s", "l", "xl"),
  easyClose = FALSE,
  fade = TRUE,
  position = c("centered", "left", "right", "top", "bottom"),
  transparent = FALSE
)
}
\arguments{
\item{...}{The elements to include within the body of the modal}

\item{title}{The text to display in the header title}

\item{footer}{Footer list of buttons or text}

\item{size}{The size of the modal, "m", "s", "l", "xl"}

\item{easyClose}{Allow simple closing, \code{FALSE} or \code{TRUE}}

\item{fade}{Allow fading away or fadin in, \code{FALSE} or \code{TRUE}}

\item{position}{Set the position of the modal. Choices include "centered","left","right","top","bottom"}

\item{transparent}{Allow background transparency, \code{FALSE} or \code{TRUE}}
}
\value{
An HTML containing elements of a modal box that remains hidden until a button is clicked
}
\description{
Advanced modal dialog that allows various positioning and transparency
}
\note{
For more information on the features of the card, visit the examples section of the help documentation
}
\examples{
\donttest{
if (interactive()) {
  library(shiny)
  library(nextGenShinyApps)
  shiny::shinyApp(
    ui = fluidPage(
      style = "8",
      custom.bg.color = "white",
      sidebar = NULL,
      header = NULL,
      shiny::h3("Modal EXAMPLES"),
      shiny::div(actionButton("obianom1", "Show BIG shiny modal on the RIGHT")),
      shiny::br(),
      shiny::div(actionButton("obianom2", "Show SMALL shiny modal on the RIGHT"))
    ),
    server = function(input, output) {
      shiny::observeEvent(input$obianom1, {
        shiny::showModal(modalDialog(
          textInput("dataset", "Enter a data set"),
          shiny::div("Id leo in vitae"),
          size = "l",
          position = "bottom",
        ))
      })
      shiny::observeEvent(input$obianom2, {
        shiny::showModal(modalDialog(
          textInput("dataset", "Enter a data set"),
          shiny::div("Lorem donec massa"),
          size = "l",
          position = "right",
        ))
      })
    }
  )
}
}
}
