% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{as_composition}
\alias{as_composition}
\alias{as_composition-method}
\alias{as_composition,numeric-method}
\alias{as_composition,matrix-method}
\alias{as_composition,data.frame-method}
\title{Coerce to a Closed Compositional Matrix}
\usage{
as_composition(from, ...)

\S4method{as_composition}{numeric}(from)

\S4method{as_composition}{matrix}(from)

\S4method{as_composition}{data.frame}(
  from,
  parts = NULL,
  groups = NULL,
  verbose = getOption("nexus.verbose")
)
}
\arguments{
\item{from}{A \code{\link{matrix}} or \code{\link{data.frame}} to be coerced.}

\item{...}{Currently not used.}

\item{parts}{A \code{vector} giving the index of the column to be used a
compositional parts. If \code{NULL} (the default), all \code{\link{double}} columns will be
used.}

\item{groups}{An \code{\link{integer}} giving the index of the column to be used to
group the samples. If \code{NULL} (the default), no grouping is stored.}

\item{verbose}{A \code{\link{logical}} scalar: should \R report extra information
on progress?}
}
\value{
A \code{\linkS4class{CompositionMatrix}} object.
}
\description{
Coerces an object to a \code{CompositionMatrix} object.
}
\details{
See \code{vignette("nexus")}.
}
\examples{
## Create a count matrix
A1 <- matrix(data = sample(1:100, 100, TRUE), nrow = 20)

## Coerce to compositions
B <- as_composition(A1)

## Row sums are internally stored before coercing to relative frequencies
totals(B)

## This allows to restore the source data
A2 <- as_amounts(B)

## Coerce to a data.frame
X <- data.frame(B)
head(X)
}
\seealso{
Other compositional data tools: 
\code{\link{as_amounts}()}
}
\author{
N. Frerebeau
}
\concept{compositional data tools}
