% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform_alr.R
\docType{methods}
\name{transform_alr}
\alias{transform_alr}
\alias{transform_alr-method}
\alias{transform_alr,CompositionMatrix-method}
\alias{transform_alr,CLR-method}
\title{Additive Log-Ratios (ALR)}
\usage{
transform_alr(object, ...)

\S4method{transform_alr}{CompositionMatrix}(object, j = ncol(object), weights = FALSE)

\S4method{transform_alr}{CLR}(object, j = ncol(object))
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{j}{An \code{\link{integer}} giving the index of the rationing part (denominator).}

\item{weights}{A \code{\link{logical}} scalar: should varying weights (column means)
be computed? If \code{FALSE} (the default), equally-weighted parts are used.
Alternatively, a positive \code{\link{numeric}} vector of weights can be specified
(will be rescaled to sum to \eqn{1}). Weights will be used internally by
other methods (e.g. \code{\link[=variance]{variance()}}).}
}
\value{
An \code{\linkS4class{ALR}} object.
}
\description{
Computes ALR transformation.
}
\details{
The ALR transformation is the logratio of a pair of parts with respect to a
fixed part.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Additive log-ratio
alr <- transform_alr(coda)

## Inverse transformation
inv_alr <- transform_inverse(alr)
all.equal(coda, inv_alr)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.

Greenacre, M. J. (2021). Compositional Data Analysis. \emph{Annual Review of
Statistics and Its Application}, 8(1): 271-299.
\doi{10.1146/annurev-statistics-042720-124436}.
}
\seealso{
Other log-ratio transformations: 
\code{\link{transform_clr}()},
\code{\link{transform_ilr}()},
\code{\link{transform_inverse}()},
\code{\link{transform_lr}()},
\code{\link{transform_plr}()}
}
\author{
N. Frerebeau
}
\concept{log-ratio transformations}
