% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_filenames}
\alias{format_filenames}
\title{Function to format filenames that can be used to unify the filenames style for 
more easily download or use}
\usage{
format_filenames(input_files = NULL, files_dir = NULL, pattern = ".*.txt",
  do.rename = FALSE, profix = "", prefix = "", replace = list(old =
  c("-", "__"), new = c("_", "_")))
}
\arguments{
\item{input_files}{Basename of files that need to be format, default is NULL 
and use the regular expression pattern to select files}

\item{files_dir}{Directory name of input files}

\item{pattern}{Use regular expression to select files in files_dir}

\item{do.rename}{If set TRUE, it will do rename step}

\item{profix}{Profix of filenames added in those without the same profix}

\item{prefix}{Prefix of filenames added in those without the same profix}

\item{replace}{Use str_replace to replace all old to new separately}
}
\description{
Function to format filenames that can be used to unify the filenames style for 
more easily download or use
}
\examples{
files_dir <- system.file('extdata', 'demo/format', package = 'ngstk')
pattern <- '*.txt'
x <- format_filenames(files_dir = files_dir, pattern = pattern, profix = 'hg38_')
}
