% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split.R
\name{split_row_file}
\alias{split_row_file}
\title{Function to split big file to a series small files (by row)}
\usage{
split_row_file(filename, each_file_lines = 100,
  use_system_split = FALSE, system_split_params = "_split",
  write_fun = "write.table", write_params_x = "x",
  write_params_file = "file", write_params = list(sep = "", row.names =
  FALSE, col.names = FALSE, quote = FALSE))
}
\arguments{
\item{filename}{Filename that need to be split}

\item{each_file_lines}{Each file row num}

\item{use_system_split}{Wheather use system split commend}

\item{system_split_params}{When use_system_split, provide the prefix and other params
default is 'split'}

\item{write_fun}{Function to read data, default is read.table}

\item{write_params_x}{Parameter name of output object in read.fun}

\item{write_params_file}{Parameter name of input file in read.fun}

\item{write_params}{Other parameters pass to write_fun}
}
\description{
Function to split big file to a series small files (by row)
}
\examples{
dat <- data.frame(col1 = 1:1000)
outfn <- tempfile()
write.table(dat, outfn, sep = '\\t', quote = FALSE, row.names = FALSE)
split_row_file(outfn)
}
