% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bbox2poly}
\alias{bbox2poly}
\title{Convert a bounding box to polygon}
\usage{
bbox2poly(bbox)
}
\arguments{
\item{bbox}{object of class bbox from sf}
}
\description{
Convert a bounding box to polygon
}
\examples{
\dontrun{
library(sf)
wk <- wikilake::lake_wiki("Gull Lake (Michigan)")

pnt <- st_as_sf(wk, coords = c("Lon", "Lat"), crs = 4326)
pnt <- st_transform(pnt, st_crs(vpu_shp))
qry <- nhd_plus_query(wk$Lon, wk$Lat,
         dsn = c("NHDWaterbody"), buffer_dist = 0.05)
wbd <- qry$sp$NHDWaterbody[which.max(st_area(qry$sp$NHDWaterbody)),]
bbox2poly(st_bbox(wbd))
}
}
