% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ellipse}
\alias{ellipse}
\title{Point coordinates for a 2-D ellipse.}
\usage{
ellipse(mu, V, alpha = 0.95, n = 100)
}
\arguments{
\item{mu}{centre of ellipse. A vector of length 2.}

\item{V}{scale of ellipse. A 2x2 matrix. See Details.}

\item{alpha}{niche region size. See Details.}

\item{n}{number of points to return for plotting.}
}
\value{
Returns a matrix of coordinates \code{cbind(x,y)} to plot a 2-dimensional ellipse.
}
\description{
Calculates coordinates of points for plotting a 2-dimensional ellipse based on
user-defined parameters. Can be used for exploratory data analysis to produce ellipses
at a given niche region size (e.g., \eqn{\alpha = 95\%}).
}
\details{
This function provides the coordinates needed to plot a 2-dimensional ellipse
based on user-defined parameters, such that \code{X = c(x,y)} satisfies the equation
\deqn{(X-\mu)' V^{-1} (X-\mu) = C,}
where \eqn{C=\code{qchisq(alpha, df = 2)}}.
}
\examples{
mu <- rnorm(2)
V <- crossprod(matrix(rnorm(4), 2, 2))
ell.pts <- ellipse(mu = mu, V = V, alpha = .9, n = 100)
plot(ell.pts, col = rainbow(110)[1:100], type = "o")
points(mu[1], mu[2], pch = "+")
}
\seealso{
\code{\link{niche.plot}}
}

