% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist_evalues.R
\name{hist_evalues}
\alias{hist_evalues}
\title{Histograms of environmental conditions in M and for occurrences (one species)}
\usage{
hist_evalues(M, occurrences, species, longitude, latitude, variable,
  CL_lines = c(95, 99), col = NULL)
}
\arguments{
\item{M}{a SpatialPolygons* object representing the accessible area (M)
for one species. See details.}

\item{occurrences}{a data.frame of occurrence records for one species. See
details.}

\item{species}{(character) name of the column in \code{occurrences} that
contains the name of the species.}

\item{longitude}{(character) name of the column in \code{occurrences} containing
values of longitude.}

\item{latitude}{(character) name of the column in \code{occurrences} containing
values of latitude.}

\item{variable}{a RasterLayer of an environmental variable of interest.
See details.}

\item{CL_lines}{(numeric) confidence limits of environmental values in M to
be plotted as lines in the histograms. See details. Default = c(95, 99).}

\item{col}{colors for lines representing confidence limits. If NULL, colors
are selected from a gray palette. Default = NULL.}
}
\description{
hist_evalues helps in creating histograms to explore environmental
conditions in M, lines for the confidence limits of values in M, and the
location of values in occurrence records, for one species at the time.
}
\details{
Coordinates in \code{occurrences}, SpatialPolygons* object in \code{M}, and
RasterLayer in \code{variable} must coincide in the geographic projection in
which they are represented. WGS84 with no planar projection is recommended.

The accessible area (M) is understood as the geographic area that has been
accessible to a species over relevant periods of time. Defining M is usually
a hard task, but also a very important one because it allows identifying
uncertainties about the ability of a species to maintain populations under
certain environmental conditions. For further details on this topic, see
Barve et al. (2011) in \url{https://doi.org/10.1016/j.ecolmodel.2011.02.011}.
}
\examples{
# getting a variable at coarse resolution
\donttest{
tmpd <- file.path(tempdir(), "bios") # temporal directory
dir.create(tmpd)
temp <- raster::getData("worldclim", var = "bio", res = 10, path = tmpd)[[1]]

# example data
data("m_list", package = "nichevol")
data("occ_list", package = "nichevol")

# running stats
hist_evalues(M = m_list[[1]], occurrences = occ_list[[1]], species = "species",
             longitude = "x", latitude = "y", variable = temp,
             CL_lines = c(95, 99), col = c("blue", "red"))
}
}
