% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrDecomp.R
\name{qrD}
\alias{qrD}
\title{The QR decomposition of a matrix}
\usage{
qrD(x, tol = 1e-07)
}
\arguments{
\item{x}{A matrix whose QR decomposition is to be computed.}

\item{tol}{The tolerance for finding linear dependence in columns of \code{x}.}
}
\value{
A list of two matrices: Q and R.
}
\description{
Computes the QR decomposition of a matrix.
}
\details{
Calls function \code{\link[base]{qr}} and returns more understandable output.
}
\examples{
hilbert <- function(n) { i <- 1:n; 1/outer(i-1,i,"+") }
h5 <- hilbert(5);
qrD(h5)

}
\seealso{
\code{\link[base]{qr}}
}
\keyword{algebra}
\keyword{linear}

