% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill-na.R
\name{fill_na}
\alias{fill_na}
\alias{fill_na.logical}
\alias{fill_na.integer}
\alias{fill_na.numeric}
\alias{fill_na.character}
\alias{fill_na.nlist}
\alias{fill_na.nlists}
\title{Fill Missing Values}
\usage{
fill_na(x, ...)

\method{fill_na}{logical}(x, value = FALSE, ...)

\method{fill_na}{integer}(x, value = 0L, ...)

\method{fill_na}{numeric}(x, value = 0, ...)

\method{fill_na}{character}(x, value = "0", ...)

\method{fill_na}{nlist}(x, value = 0L, ...)

\method{fill_na}{nlists}(x, value = 0L, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{value}{A scalar of the value to replace missing values with.}
}
\value{
The object with missing values filled.
}
\description{
Fills missing values.
}
\section{Methods (by class)}{
\itemize{
\item \code{logical}: Fill missing values of logical object

\item \code{integer}: Fill missing values of integer object

\item \code{numeric}: Fill missing values of numeric object

\item \code{character}: Fill missing values of character object

\item \code{nlist}: Fill missing values of nlist object

\item \code{nlists}: Fill missing values of nlist object
}}

\examples{
fill_na(nlist(x = c(2, NA), y = matrix(c(1:3, NA), nrow = 2)))
fill_na(nlists(nlist(x = c(2, NA)), nlist(x = c(NA_real_, NA))))
}
