% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverageplot}
\alias{coverageplot}
\title{The coverage plot}
\usage{
coverageplot(orig_data,
             sim_data,
             N_xbin = NULL,
             pred.level = c(0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9),
             conf.level = 0.95,                         
             X_name = "TIME",
             Y_name = "DV",
             MissingDV = NULL,
             plot_flag = TRUE,
             linesize = 0.7,
             pointsize = 1.5,
             Kmethod = "cluster",                
             maxK = NULL,
             beta = 0.2,
             lambda = 0.3,
             R = 4,
             C1 = 2.5,
             C2 = 7.8, ...)
}
\arguments{
\item{orig_data}{A data frame of original data with X and Y variable.}

\item{sim_data}{A matrix of simulated data with only Y values collected.}

\item{N_xbin}{Number of bins in X variable. If NULL, optimal number of bins are automatically calculated using optK function.}

\item{pred.level}{Numeric vector of probabilities.}

\item{conf.level}{Confidence level of the interval.}

\item{X_name}{Name of X variable in orig_data (usually "TIME" in pharmacokinetic data).}

\item{Y_name}{Name of Y variable in orig_data (usually "DV" in pharmacokinetic data).}

\item{MissingDV}{Name of missing indicator variable in orig_data, which have value 1 if missing, value 0 otherwise. (usually "MDV" in pharmacokinetic data).}

\item{plot_flag}{Draw plot if TRUE; generate data for drawing plot if FALSE.}

\item{linesize}{Size of line in the plot.}

\item{pointsize}{Size of point in the plot.}

\item{Kmethod}{The way to calculate the penalty in automatic binning."cluster" or "kernel".}

\item{maxK}{Yhe maximum number of bins.}

\item{beta}{Additional parameter for automatic binning, used in optK function.}

\item{lambda}{Additional parameter for automatic binning, used in optK function.}

\item{R}{Additional parameter for automatic binning, used in optK function.}

\item{C1}{Additional parameter for automatic binning, used in optK function.}

\item{C2}{Additional parameter for automatic binning, used in optK function.}

\item{...}{arguments to be passed to methods}
}
\value{
coverage plot
}
\description{
The coverage plot is developed to help visually check 
the fitted model with the NPC result.
In each level of the predicted interval, the ratios between the expected 
number of points (Exp) outside the prediction interval and the observed 
number of data (Obs) outside the prediction interval are calculated.
These ratios on the upper and lower sides of the prediction interval 
are calculated separately.
}
\examples{
\donttest{
data(origdata)
data(simdata)
coverageplot(origdata,simdata,N_xbin=8)
}

}
\references{
Holford N, & Karlsson M. (2008). "A tutorial on visual predictive checks,
 abstr 1434." Annual Meeting of the Populations Approach Group in Europe. www.page-meeting.org. 2008.
}
