% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxtable.R
\name{nmDocx}
\alias{nmDocx}
\alias{nmSave}
\title{Create a run summary word document}
\usage{
nmDocx(x, docxOut = NULL, docxTemplate = NULL, plot = TRUE,
  titleStyle = getOption("nlmixr.docx.title", "Title"),
  subtitleStyle = getOption("nlmixr.docx.subtitle", "Subtitle"),
  normalStyle = getOption("nlmixr.docx.normal", "Normal"),
  headerStyle = getOption("nlmixr.docx.heading1", "Heading 1"),
  centeredStyle = getOption("nlmixr.docx.centered", "centered"),
  preformattedStyle = getOption("nlmixr.docx.preformatted",
  "HTML Preformatted"), width = getOption("nlmixr.docx.width", 69),
  save = FALSE)

nmSave(x, ..., save = TRUE)
}
\arguments{
\item{x}{nlmixr fit object.}

\item{docxOut}{Output file for run information document.  If not
specified it is the name of R object where the fit is located
with the \code{-YEAR-MONTH-DAY.docx} appended.  If it is
\code{NULL} the document is not saved, but the \code{officer}
object is returned.}

\item{docxTemplate}{This is the document template.  If not
specified it defaults to
\code{option("nlmixr.docx.template")}.  If
\code{option("nlmixr.docx.template")} is not specified it uses
the included nlmixr document template.  When
\code{docxTemplate=NULL} it uses the \code{officer} blank
document.}

\item{plot}{Boolean indicating if the default goodness of fit
plots are added to the document.  By default \code{TRUE}}

\item{titleStyle}{This is the word style name for the nlmixr
title; Usually this is \code{nlmixr version (R
object)}. Defaults to \code{option("nlmixr.docx.title")} or
\code{Title}}

\item{subtitleStyle}{This is the word style for the subtitle which
is \code{nlmixr model name and date}. Defaults to
\code{option("nlmixr.docx.subtitle")} or \code{Subtitle}}

\item{normalStyle}{This is the word style for normal text. Defaults to
\code{option("nlmixr.docx.normal")} or \code{Normal}}

\item{headerStyle}{This is the word style for heading text. Defaults to
\code{option("nlmixr.docx.heading1")} or \code{Heading 1}}

\item{centeredStyle}{This is the word style for centered text
which is used for the figures. Defaults to
\code{option("nlmixr.docx.centered")} or \code{centered}}

\item{preformattedStyle}{This is the preformatted text style for R
output lines.  Defaults to
\code{option("nlmixr.docx.preformatted")} or \code{HTML Preformatted}}

\item{width}{Is an integer representing the number of characters
your preformatted style supports.  By default this is
\code{option("nlmixr.docx.width")} or \code{69}}

\item{save}{Should the docx be saved in a zip file with the R rds
data object for the fit?  By default this is \code{FALSE} with
\code{nmDocx} and \code{TRUE} with \code{nmSave}}

\item{...}{when using `nmSave` these arguments are passed to `nmDocx`}
}
\value{
An officer docx object
}
\description{
Create a run summary word document
}
\examples{
\dontrun{
 library(nlmixr)
pheno <- function() {
    # Pheno with covariance
  ini({
    tcl <- log(0.008) # typical value of clearance
    tv <-  log(0.6)   # typical value of volume
    ## var(eta.cl)
    eta.cl + eta.v ~ c(1,
                       0.01, 1) ## cov(eta.cl, eta.v), var(eta.v)
                      # interindividual variability on clearance and volume
    add.err <- 0.1    # residual variability
  })
  model({
    cl <- exp(tcl + eta.cl) # individual value of clearance
    v <- exp(tv + eta.v)    # individual value of volume
    ke <- cl / v            # elimination rate constant
    d/dt(A1) = - ke * A1    # model differential equation
    cp = A1 / v             # concentration in plasma
    cp ~ add(add.err)       # define error model
  })
}

fit.s <- nlmixr(pheno, pheno_sd, "saem")

## Save output information into a word document
nmDocx(fit.s)

}
}
\author{
Matthew Fidler
}
