% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npde.R
\name{tableControl}
\alias{tableControl}
\title{Output table/data.frame options}
\usage{
tableControl(
  npde = NULL,
  cwres = NULL,
  saemNPDE = FALSE,
  saemCWRES = FALSE,
  nlmeNPDE = FALSE,
  nlmeCWRES = FALSE,
  foceiNPDE = FALSE,
  foceNPDE = FALSE,
  nsim = 300,
  ties = TRUE,
  seed = 1009
)
}
\arguments{
\item{npde}{When TRUE, request npde regardless of the algorithm used.}

\item{cwres}{When TRUE, request CWRES and FOCEi likelihood
regardless of the algorithm used.}

\item{saemNPDE}{When TRUE and estimating with SAEM, adds NPDE
metrics to fit including EPRED, ERES, and NPDE. (default
TRUE);}

\item{saemCWRES}{When TRUE and estimating with SAEM, adds CWRES
metrics to the fit including CPRED, CRES and CWRES.  It also
evaluates the function with the FOCEi objective function to
allow comparison between estimation methods. (default FALSE)}

\item{nlmeNPDE}{When TRUE and estimating with nlme, adds NPDE
metrics to fit including EPRED, ERES, and NPDE. (default
TRUE);}

\item{nlmeCWRES}{When TRUE and estimating with nlme, adds CWRES
metrics to the fit including CPRED, CRES and CWRES.  It also
evaluates the function with the FOCEi objective function to
allow comparison between estimation methods. (default FALSE)}

\item{foceiNPDE}{When TRUE and estimating with FOCEi, adds NPDE
metrics to fit including EPRED, ERES, and NPDE. (default
TRUE);}

\item{foceNPDE}{When TRUE and estimating with FOCEi, adds NPDE
metrics to fit including EPRED, ERES, and NPDE. (default
TRUE);}

\item{nsim}{Number of simulations.  By default this is 300}

\item{ties}{When TRUE, the npde distribution can have ties.  When
FALSE, the npde distribution uses uniform random numbers to
prevent ties.}

\item{seed}{Seed for running nlmixr simulation.  By default 1009}
}
\value{
A list of table options for nlmixr
}
\description{
Output table/data.frame options
}
\details{
If you ever want to add CWRES/FOCEi objective function you can use the \code{\link{addCwres}}

If you ever want to add NPDE/EPRED columns you can use the \code{\link{addNpde}}
}
\author{
Matthew L. Fidler
}
